$TITLE CPE2C_task Cobb-Douglas consumer model with missing elements
$ONTEXT
CPE2C_task
Programmed by Hans Lofgren, IFPRI, November 1999.
Adapted by Rob Davies and Dirk van Seventer, July 2004 and March 2007
$OFFTEXT

SET

 C  commodities
    /AGR-C  agricultural commodity,
     NAGR-C  non-agricultural commodity/
    ;
 ALIAS(C,CP);

PARAMETER
 CONSVAL(C) base-year consumption values (LCU)
*Complete!!
 /                     /

 INCOME base-year income or expenditure (LCU)
 ;
*Complete!!
 INCOME =                   ;

DISPLAY INCOME;

PARAMETERS
 beta(C)   share of h-hold consumption spending on commodity c
 p(C)      market price of commodity c (LCU)
 yh        household income (LCU)
 U         household utility
 ;
VARIABLE
 QH(C)     quantity of household consumption of c (base-year LCU)
 ;
EQUATION
 HHDEM(C)  consumption demand for commodity c
 ;
*Complete!!
 HHDEM(C)..                            ;

MODEL
 CPE2C Cobb-Douglas consumer model
 /HHDEM/
 ;

*================================================
*CALIBRATION=====================================
*================================================

PARAMETERS

*Parameter used to define initial variable levels.
 QH0(C)    quantity of household consumption of c (base-year LCU)

*Parameter used to define base values that are changed in simulations.
 P0(C)     base market price of commodity c (LCU)

*Parameter used to define base utility
 U0        base level utility

 ;

 P0(C)  = 1;
* P0(C)  =1.1;

 p(C)   = P0(C);

 yh     = INCOME;

*Complete!!
 beta(C)  =                                ;
*Complete!!
 QH0(C) =                ;
*Complete!!
 U0    =                         ;

*Initializing variables
*Complete!!
 QH.L(C)  =       ;
*Complete!!
 U    =                          ;
*================================================
*SOLVING FOR BASE================================
*================================================

SOLVE CPE2C USING MCP;

DISPLAY
 P0, p, yh, beta, QH0, QH.L, U0, U;